#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import os
from pathlib import Path

ROOT_DIR = os.environ.get('PSP_PATH')
if not ROOT_DIR:
    print('[ERROR] 环境变量 PSP_PATH 未设置！')
    os.system('pause >nul')
    exit(1)

OLD_STR = r'%1 mshta vbscript:CreateObject("Shell.Application").ShellExecute("cmd.exe","/c ""%~s0"" ::","","runas",1)(window.close)&&exit'
NEW_STR = r'''NET SESSION >nul 2>&1 || powershell -Command "Start-Process cmd -ArgumentList '/c, ""%~f0""' -Verb RunAs" && exit /b'''

def replace_keep_original(file_path: Path, old: str, new: str) -> bool:
    """返回 True 表示确实发生了替换"""
    try:
        data = file_path.read_bytes()
        text = data.decode('gbk')
    except UnicodeDecodeError:
        text = data.decode('gbk', errors='ignore')

    if old not in text:
        return False

    text = text.replace(old, new)
    file_path.write_bytes(text.encode('gbk'))
    return True

def main():
    replaced = []                      # 收集被替换的文件
    for f in Path(ROOT_DIR).rglob('*.bat'):
        if replace_keep_original(f, OLD_STR, NEW_STR):
            replaced.append(str(f))

    if replaced:
        print('已替换的脚本：')
        print('\n'.join(replaced))
    else:
        print('本次没有脚本被替换。')
    print('按下任意键退出...')
    os.system('pause >nul')            # 任意键退出

if __name__ == '__main__':
    main()